// 
// Copyright (C) 2007, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//
#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;

using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;

using System.Net;  ///Need this to use   WebClient client = new WebClient();
using System.Reflection;

 
#endregion

// Add this to your declarations to use StreamReader
using System.IO;
using System.IO.Compression;
using System.Diagnostics;

//Export Notes:
	//Needs to be exported with the following references, 	
		//System.Net.Http.dll
		//System.IO.Compression.FileSystem.dll

///Notes:
/// 	The data is from the tuesday before.
/// 	Data is pulled from reports that are released friday after close.
/// 	Indicator needs to be updated after Jan 1 2018, Contact, Alan Palmer at, alan.palmer@ninjatrader.com or 
/// 	you may send an email to platformsupport[at]ninjatrader[dot]com with Attn: Alan P in the Subject line.

///Additional Notes at the bottom.


// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.NinjaScript.Indicators.AlanIndicators
{
	
    public class OpenInterestARP : Indicator
    {
        #region Variables
		private Series <double> openInterestDataSeries ;  //Creates the OI data series.
	
		private string pathThisYear 				= NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\" +"f_year.txt";
		private string	pathPreThisYear = NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\"+ "F_Disagg06_16.txt";  //Will likley change this on new year,

		private string pathThisYearFinancials 				= NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\" +"FinFutYY.txt";
		private string	pathPreThisYearFinancials 		    = NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\" +"F_TFF_2006_2016.txt";  //Will likley change this on new year,
		
		string[] xSplit1;  ///Makes an array containing the prased values.
	
		public List <NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass> myList; //Creating a list, of type myCustomClass, which takes Date and OI.
			
		private int AmountOfBarsTotal;
		
		private bool doOnceNullValue =false;
		
		private bool indicatorExpired =false;
		
		//Used in PullDataCFTC method
		private string url2017="http://www.cftc.gov/files/dea/history/fut_disagg_txt_2017.zip";
		private string urlPre17="http://www.cftc.gov/files/dea/history/fut_disagg_txt_hist_2006_2016.zip";
		private string downloadLocation2017 ="COTDataFolder\\CurrentYearData.zip";
		private string downloadLocationPre2017 ="COTDataFolder\\Pre2017YearData.zip";

		/// Financial Futures Data
		private string url2017Financials="http://www.cftc.gov/files/dea/history/fut_fin_txt_2017.zip";
		private string urlPre17Financials="http://www.cftc.gov/files/dea/history/fin_fut_txt_2006_2016.zip";
		private string downloadLocation2017Financials ="COTDataFolder\\CurrentYearDataFinancials.zip";
		private string downloadLocationPre2017Financials ="COTDataFolder\\Pre2017YearDataFinancials.zip";
		
		 
        #endregion

        protected override void OnStateChange()
        {
			if(State == State.SetDefaults)
			{
				Calculate			= Calculate.OnBarClose;
				Name				= "OpenInterestARP";
				AddPlot(Brushes.Red, "OpenInterest");
				
			}
			else if(State == State.Historical)
			{						
				Print("State.Historical Running");
				//Warning to only run this on COBC
				if(Calculate != Calculate.OnBarClose)
				{
					Draw.TextFixed(this, "NinjaScriptInfo", "WARNING: SET CALCULATE TO ONBARCLOSE", TextPosition.Center);
					Log("WARNING: SET CALCULATE TO ONBARCLOSE", LogLevel.Error);
					return;
				}
				//Warning to only run this on weekly chart.
				if (BarsPeriod.BarsPeriodType != BarsPeriodType.Week)  //Putting a warning up if this is not applied to a Weekly Chart.
				{
					Draw.TextFixed(this, "NinjaScriptInfo", "WARNING: ONLY USE THIS INDICATOR ON WEEKLY CHARTS", TextPosition.Center);
					Log("WARNING: ONLY USE THIS INDICATOR ON WEEKLY CHARTS", LogLevel.Error);
					return;
				}
				
			}
			else if (State == State.Configure)
			{
			
				openInterestDataSeries= new Series<double>(this);
				fixIndicatorForNewYear();
			
			}			
			else if(State ==State.DataLoaded)
			{		
				Print("DataLoaded Running");
				
				AmountOfBarsTotal =Bars.Count; //This saves how many bars on on chart. 
		
				//Print("AmountOfBarsTotal"+AmountOfBarsTotal.ToString());
				
				//Checks if the folder exists, if it doesn't, it will be created.
				if(!Directory.Exists(NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\" ))
				{
					Print("Creating COT Data Folder");
						 Directory.CreateDirectory(NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\");
				}
			
				CreateListAndAddDummyMethod(); //Creating a list, adding 1 row of 0's.
				
				if (!File.Exists(pathThisYear))  //If this years data file exits, don't pull data.
				{
					DownloadDataCFTC(url2017, downloadLocation2017);
					unzip( downloadLocation2017);
				}
				if (!File.Exists(pathPreThisYear)) //If pre this year file exits, don't pull data.
				{
					DownloadDataCFTC(urlPre17, downloadLocationPre2017);
					unzip( downloadLocationPre2017);
				}
				if (!File.Exists(pathThisYearFinancials))  //If this years financial datafile exits, don't pull data.
				{
					DownloadDataCFTC(url2017Financials, downloadLocation2017Financials);
					unzip(downloadLocation2017Financials);
				}
				if (!File.Exists(pathPreThisYearFinancials))  //If Pre this years financial datafile exits, don't pull data.
				{
					DownloadDataCFTC(urlPre17Financials, downloadLocationPre2017Financials);
					unzip(downloadLocationPre2017Financials);
				}
					
				AddDataToListFromBothFiles(); //If our .txt files exist in COTDataFolder, it will add both to the list.
				//if they don't exist, method will return, and we will run this method in state.historical which gives us enough
				//time for them to download.			
				
				//CheckIfTodayIsPastNewReportDate()-Checks the lists time against todays time, if new report is out, one will be downloaded..
				CheckIfTodayIsPastNewReportDate(pathThisYear, url2017 ,downloadLocation2017);
				CheckIfTodayIsPastNewReportDate(pathThisYearFinancials, url2017Financials, downloadLocation2017Financials);
				///if last data entry ( 2 actually since dummy), is older than 10 days ago, download new file and update my list.
			
			}
			else if(State == State.Terminated)
			{

			}
			
		}
		private bool doOnce=false;
		private int addOne=0;
		private int startingPoint=0;

	
        protected override void OnBarUpdate()
        {			
			if(indicatorExpired ==true) return;  //Preventing Bad data due to new year.  Set in method. fixIndicatorForNewYear
			
			///Problem is that if my list is longer than Amount of bars in series, the value of today is actually the difference between the two off.
			if(CurrentBar>=AmountOfBarsTotal - myList.Count())
			{
				if(doOnce==false)  ///Without this, list was reversing over and over.
				{
					if(myList.Count()>AmountOfBarsTotal)  //If our list is bigger than bars in dataseries, we need to add the difference to our starting point of where we start matching 
						 startingPoint = myList.Count() -AmountOfBarsTotal;  //Since we match first bar with 1st OI in our list, if our list is greater than bars on chart, it'll start matching wrong.
								
					//Instead of reversing, we are sorting by myTime column. This is more proper.	
					//myList.Reverse();  //Need this to happen only once.
					myList= myList.OrderBy(e => e.myTime).ToList();
					doOnce=true;
				}
				//Setting openInterestDataSeries to my List.
					//We add "startingPoint" which is the difference between the bars in data series, and how many values we have in a list.  If list is bigger, values were goofing up.
				openInterestDataSeries[0]= myList[startingPoint+addOne].myOI; 
				//Setting Plot to our OpenInterestDataSeries	
				Values[0][0]=openInterestDataSeries[0];
				
				///Check: Making Sure the DateTime of our List being Matched with the plot are within a week of each other.
				if(myList[startingPoint+addOne].myTime < Time[0].AddDays(-7)) //If today minus 7 days, is still greater than myList.Time, display warning that times not mathcin.
					Print("DATA IS BAD, Matching OI Data of"+myList[startingPoint+addOne].myTime.ToString() +"With"+ Time[0].ToString());
				addOne++;
				
					}		
			
        }		

		public void CreateListAndAddDummyMethod()  //Void cause it has no output or return value
		{
			//Create List Once and Add a Dummy Value.
			if(doOnceNullValue ==false)
			{
				Print("Creating List 1st Time and Adding Dummy Value");
				//Creating a list, which our method will be adding to.
				myList= new List <NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass> ();
			
				///***Adding Dummy Value to top of myList, to push back the most recent value 1 bar.  Otherwise you have to run strategy oneachtick to see the most recent data point.
				myList.Add(new NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass { myTime =  DateTime.Now, myOI = 0} );  //Adding dummy before loop, 
			
				doOnceNullValue =true;  //Preventing this block from running again.
			}
		}
		
		//This method is ran if our last value in list/file, was older than the most recent CFTC expected report date,
		//and we needed to download new file, clear our list, add the dummy value, to make it ready to re-add data to our list.
		public void ClearListReAddDummyValue()
		{			
			myList.Clear();
			///***Adding Dummy Value to top of myList, to push back the most recent value 1 bar.  Otherwise you have to run strategy oneachtick to see the most recent data point.
			myList.Add(new NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass { myTime =  DateTime.Now, myOI = 0} );  //Adding dummy before loop, 
		}
	
		public void AddDataToListFromBothFiles()
		{
			///Try adding to lists
			try
			{	
					Print("Adding Data to List");
				///post 2017 Data
					AddDataToListMethod(CotMethodAlan(ContractEnum), pathThisYear, ContractEnum);  //CotMethodAlan converts the enum to its Long Name, in string form.
		
				///post 2017 Data Financials
					AddDataToListMethod(CotMethodAlan(ContractEnum), pathThisYearFinancials, ContractEnum);
					
				///Pre 2017 Data					
					AddDataToListMethod(CotMethodAlan(ContractEnum), pathPreThisYear, ContractEnum);
				///Pre 2017 Data Financial
					AddDataToListMethod(CotMethodAlan(ContractEnum), pathPreThisYearFinancials, ContractEnum);
			}
			catch (Exception e)
			{
				// Outputs the error to the log
				Log("AddDataToListFromBothFiles() Try Loop error ", NinjaTrader.Cbi.LogLevel.Error);
				Print(e.ToString());
			}		
		}

		public void AddDataToListMethod(String c1, String p1, NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 e)  //C is contract enum, p is Path String
		{
			if (!File.Exists(p1))
			{
	
				Print("File does not exist.");	// If file does not exist, let the user know			
				return;
			}		
			
			StreamReader s1;
		
			s1 = new System.IO.StreamReader(p1);
		
			string Line1;
			string[] sSplit1;
			
			while ((Line1 = s1.ReadLine()) != null) 
			{
				sSplit1 =  Line1.Split(new char[] {','}, StringSplitOptions.None);	
					
		///Special Handeling of Specific Contracts:
				/// 	Building Additional Notes.
				/// 		If the contracts have a different name pre a certain year, use the same block as wheat.
				/// 		If the contract has a comma in its name, use the crude block b low.
				/// 		If the contract has a extra space in its name, (Could build one for RBOB, for now omitting pre 2015 data)....
				
				///If Contract = Crude:  We Need special handling because it has a comma in its name, which causes our columns to be off and need extra consideration for finding.	
				if(e == NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1.Crude)
				{										///You need to look 2nd column over, since Crude Oil is 1 col, Light Sweet is next.
					if(sSplit1[0].Equals("\""+(c1)) && (sSplit1[1].Equals(" LIGHT SWEET - NEW YORK MERCANTILE EXCHANGE"+"\""))  )  //Dealing with crude oil having a name betwen crude oil, light sweet.  Moves the data on line over one, and also requires us to check 2nd colmunm  for  LIGHT SWEET - NEW YORK MERCANTILE EXCHANGE" 
					{
						//Print("Adding"+e.ToString());
						///Since CL has extra "," in name, we need to shift which row we parse from 2 for date to 3, and 7 for OI to 9.
						myList.Add(new NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass { myTime =  DateTime.Parse(sSplit1[3]) , myOI = double.Parse(sSplit1[8])} );
						
					}
				}
				///If Contract = Wheat:  Need special handleing because previous to 2014, CBOT wheat went by different name.
				///Need to Add Quotes to the name we are searching for, cause wheat is in the file as "WHEAT - CHICAGO BOARD OF TRADE"
				else if(e == NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1.Wheat)
				{	
					if(sSplit1[0].Equals(("\"" +(c1) +"\"")) || (sSplit1[0].Equals("\"" +"WHEAT - CHICAGO BOARD OF TRADE"+"\"")))  //Dealing with crude oil having a name betwen crude oil, light sweet.  Moves the data on line over one, and also requires us to check 2nd colmunm  for  LIGHT SWEET - NEW YORK MERCANTILE EXCHANGE" 
					{
						//Print("Adding"+e.ToString());
						myList.Add(new NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass { myTime =  DateTime.Parse(sSplit1[2]) , myOI = double.Parse(sSplit1[7])} );
				//	 (sSplit[0].Equals("\"" +CotMethodAlan(c) +"\""))) 
						
					}
				}
				///Typical Handleing:  No Issues with Name.
				else if(sSplit1[0].Equals((c1).ToString())   || (sSplit1[0].Equals("\"" +(c1) +"\"")))     					
				{
				//	Print("Adding"+e.ToString());
					myList.Add(new NinjaTrader.NinjaScript.Indicators.AlanIndicators.myCustomClass { myTime =  DateTime.Parse(sSplit1[2]) , myOI = double.Parse(sSplit1[7])} ); //Turning xSPlit into a double
				
				}
				
			///Known Issues we Omit Solution for now:
				///RBOB issue.  Pre 2015-06-16, RBOs name has extra space.  So you'd have to have special handling like you do for crode above.
					///	"GASOLINE BLENDSTOCK (RBOB) - NEW YORK MERCANTILE EXCHANGE"
					///	"GASOLINE BLENDSTOCK (RBOB)  - NEW YORK MERCANTILE EXCHANGE"
			}
			
			if (s1  != null)
			{
				s1.Dispose();
				s1  = null;
			}
						
		}
			 
		public void DownloadDataCFTC(string url, string downloadLocation)
		{
			string s=url;
			string x=NinjaTrader.Core.Globals.UserDataDir + downloadLocation;	
			
			try
	        {      
				using (WebClient webClient = new WebClient())  //If this is failing, delete the .zip folder in folder.
				{
				   webClient.DownloadFile(url, x);
				}
		     }
            catch (Exception err)
            {
                throw new Exception("Sorry there was an error with DownloadDataCFTC(): " + err.Message);
            }
		}
	
		private void unzip(string z)
		{
			Print("Unziping" +z.ToString());
			
			string zipPath = (NinjaTrader.Core.Globals.UserDataDir+z );  //Using these paths worked.
			///Where we want the files extracted to.
			string extractPath =	NinjaTrader.Core.Globals.UserDataDir +"COTDataFolder\\" ;
		
			ZipFile.ExtractToDirectory(zipPath, extractPath);
		}
		
	
		
		public void CheckIfTodayIsPastNewReportDate(string pathC, string urlC, string downloadlocationC )
			{
			
				if (File.Exists(pathC) && (DateTime.Now > myList[1].myTime.AddDays(10).AddHours(14)) )  //If file exits, don't pull data.
				{
					Print("Newer Data Expected out, deleting .txt file, downloading new .zip, unzipping, clearing list, creating new dummy value, and adding data to list");
					
					File.Delete(pathC);  //Delete the file before redownloading/unzipping, to avoid error where the file already exits.
					
					DownloadDataCFTC(urlC, downloadlocationC);  //Downloading new .zip file for current year.
					
					unzip(downloadlocationC);  //Unzipping this new file.
					
					//Need to clear everything from the list, and ReAdd a Dummy Value.  This is different than our CreateListAndAddDummyMethod we earlier ran,
					//which Creates a list and adds a dummy value, caluse this time the list is already created, so just need to add dummy value.
					ClearListReAddDummyValue();
	
					//Adding data to our list.
					AddDataToListFromBothFiles();  //Need to add the fresh data to the list
				}
			}
			      
		private void fixIndicatorForNewYear()   ///Use to halt indicator from working after 2018.
		{
			///Due to needing to swap the current year file path for 2017 to 2018, putting this method in,
			/// which will terminate the indicator if the current year is 2018.  
			DateTime shutOffDate= new DateTime(2018,1,1);
	
			if(DateTime.Now>shutOffDate) 
			{
				indicatorExpired =true;
				
				Log("Need to fix current year data link, Contact Alan Palmer", LogLevel.Error);
				Print("Need to fix current year data link, Contact Alan Palmer");
				Draw.TextFixed(this, "NinjaScriptInfo", "Need to fix current year data link, Contact Alan Palmer", TextPosition.Center);
				
				return;
			}
		}
		public string CotMethodAlan(NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 t)  //This doesn't need to be static, think that would only be if it was in addon folder.
		{
			string[] formalName = new string[]
			{
				"WHEAT-SRW - CHICAGO BOARD OF TRADE",  //Wheat Also goes by "WHEAT - CHICAGO BOARD OF TRADE", pre 2014.  See this line for how we handled. >>>	else if(e == NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1.Wheat) 
				"CORN - CHICAGO BOARD OF TRADE",
				"SOYBEANS - CHICAGO BOARD OF TRADE",
				"SOYBEAN OIL - CHICAGO BOARD OF TRADE",
				"SOYBEAN MEAL - CHICAGO BOARD OF TRADE",
				
				"GOLD - COMMODITY EXCHANGE INC.",
				"SILVER - COMMODITY EXCHANGE INC.",
				"COPPER-GRADE #1 - COMMODITY EXCHANGE INC.",
				"PLATINUM - NEW YORK MERCANTILE EXCHANGE",
			
				"CRUDE OIL",//  See how we handled issue on line>>>>  if(e == NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1.Crude)
			
				"GASOLINE BLENDSTOCK (RBOB)  - NEW YORK MERCANTILE EXCHANGE",
				"SUGAR NO. 11 - ICE FUTURES U.S.",		
				
				//Pre 2017 data, Financial Data does not use quotes.  THe following line checks for name with and without quotes, else if(sSplit1[0].Equals((c1).ToString())   || (sSplit1[0].Equals("\"" +(c1) +"\"")))  
				"AUSTRALIAN DOLLAR - CHICAGO MERCANTILE EXCHANGE",
				"BRITISH POUND STERLING - CHICAGO MERCANTILE EXCHANGE",
				"CANADIAN DOLLAR - CHICAGO MERCANTILE EXCHANGE",
				"EURO FX - CHICAGO MERCANTILE EXCHANGE",     
				"JAPANESE YEN - CHICAGO MERCANTILE EXCHANGE",
				"SWISS FRANC - CHICAGO MERCANTILE EXCHANGE",
								
				"DJIA Consolidated - CHICAGO BOARD OF TRADE",	
				"DOW JONES INDUSTRIAL AVG- x $5 - CHICAGO BOARD OF TRADE",
							
				//For ES and NQ, using consolidated (Small plus bigs), 		
				"S&P 500 Consolidated - CHICAGO MERCANTILE EXCHANGE",
				"E-MINI S&P 500 STOCK INDEX - CHICAGO MERCANTILE EXCHANGE",
								
				"NASDAQ-100 Consolidated - CHICAGO MERCANTILE EXCHANGE",
				"NASDAQ-100 STOCK INDEX (MINI) - CHICAGO MERCANTILE EXCHANGE",	
						
				"2-YEAR U.S. TREASURY NOTES - CHICAGO BOARD OF TRADE",
				"5-YEAR U.S. TREASURY NOTES - CHICAGO BOARD OF TRADE",
				"10-YEAR U.S. TREASURY NOTES - CHICAGO BOARD OF TRADE",
				"U.S. TREASURY BONDS - CHICAGO BOARD OF TRADE",
				
			};
			
			return formalName[(int) t];  //Taking the Enum value, converting it to its int (the number down the list), and returning the equiv here.
		}
		

        #region Properties
			
		[NinjaScriptProperty]
		[Display(Name="ContractType", Description="", Order=2, GroupName="Other")]
		public NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 ContractEnum
		{ get; set; }
		
			
		[Browsable(false)]
		[XmlIgnore]		
        public Series <double> OpenInterestDataSeries  //Alows us to get the plot series of 1, 0, - depending on gap up, no gap, or gap down.
        {
            get {Update(); return openInterestDataSeries; }	
			//get {return openInterestDataSeries; }	
        } 

		#endregion
		
		
///Notes, Plans, Info.
/// If you want OI back to 1986, you would replace the paths I have with these.  You may have to add more filters, as there is Board of Trade Gold, 
/// so look at how you filtered wheat.  I confirmed the data is the same, just goes back to 1986.
/// /// No point in this project since kinetick data doesn’t go back further.
///http://www.cftc.gov/files/dea/history/deacot2017.zip
///http://www.cftc.gov/files/dea/history/deacot1986_2016.zip
/// 
///To add contents of a list,
///			foreach(myCustomClass c in myList)
///			{
///				mySum += c.myOI; //myOI is always refering to the 7th column (or 6th), set in 137.
///	}

///Notes:
		///finding the index in the list by the object.
			///myList.IndexOf(new myCustomClass);   //
		///Using the index to get the object.
			///	Print(myList[3].myOI.ToString());  //3rd row in myOI column.  0 is top row, then continue down list.

	/// Notes Regarding This not working in Strategy.
	/// For some reason, the most recent value of the OI, is OpenInterest[0] historically.  Plot looks good, but 
	/// if you have condition is openinterst[0]> a value, Every bar back is that recent value.
	/// Solution:
	/// 	Going to have to copy paste this code into a strategy for it to work.
	/// To be able to use this in a strategy, you may have to copy the code over.  Fo
	///*************************************************************************
	
	///Reports Found ehre, "Disaggregated Futures Only Reports:"
		/// http://www.cftc.gov/MarketReports/CommitmentsofTraders/HistoricalCompressed/index.htm
		/// 
		//To check OI values, you go to CME, check the last report on tesday,
		///http://www.cmegroup.com/trading/agricultural/grain-and-oilseed/wheat_quotes_settlements_futures.html#tradeDate=08/02/2017
		/// 
		
		///To CHeck Financial Futures, download this,
		/// http://www.cftc.gov/files/dea/history/fut_fin_xls_2017.zip  Compare most recent day against chart then
		/// compare it to CME>Settlement and pick the wednesday.  (reports are as of tuesday).
		
///Checks:  Links where you can check the data against.
		/// Wheat: https://www.quandl.com/data/CFTC/W_F_ALL-Commitment-of-Traders-Wheat-Srw-Futures-Only-001602
		/// Beas: https://www.quandl.com/data/CFTC/S_F_ALL-Commitment-of-Traders-Soybeans-Futures-Only-005602
		/// Meal: https://www.quandl.com/data/CFTC/SM_F_L_ALL-Commitment-of-Traders-Soybean-Meal-Futures-Only-Legacy-Format-026603
		/// BeanOil: https://www.quandl.com/data/CFTC/BO_F_ALL-Commitment-of-Traders-Soybean-Oil-Futures-Only-007601
		/// Euro: https://www.quandl.com/data/CFTC/EC_F_L_ALL-Commitment-of-Traders-Euro-Fx-Futures-Only-Legacy-Format-099741
		/// Yen: https://www.quandl.com/data/CFTC/JY_F_L_ALL-Commitment-of-Traders-Japanese-Yen-Futures-Only-Legacy-Format-097741
		/// Canadian dollar http://www.cmegroup.com/trading/fx/g10/canadian-dollar_quotes_settlements_futures.html#tradeDate=08/01/2017
		/// Assie : https://www.quandl.com/data/CFTC/AD_F_L_ALL-Commitment-of-Traders-Australian-Dollar-Futures-Only-Legacy-Format-232741
		///British Pound: https://www.quandl.com/data/CFTC/BP_F_L_ALL-Commitment-of-Traders-British-Pound-Sterling-Futures-Only-Legacy-Format-096742
	
		/// Gold: https://www.quandl.com/data/CFTC/GC_F_ALL-Commitment-of-Traders-Gold-Futures-Only-088691
		/// Silver: https://www.quandl.com/data/CFTC/SI_F_ALL-Commitment-of-Traders-Silver-Futures-Only-084691
		/// Platinum: https://www.quandl.com/data/CFTC/PL_F_L_ALL-Commitment-of-Traders-Platinum-Futures-Only-Legacy-Format-076651
		/// RBOB: https://www.quandl.com/data/CFTC/RB_F_ALL-Commitment-of-Traders-Gasoline-Blendstock-Rbob-Futures-Only-111659
		/// Sugar: https://www.quandl.com/data/CFTC/SB_F_ALL-Commitment-of-Traders-Sugar-No-11-Futures-Only-080732
		/// ES https://www.quandl.com/data/CFTC/ES_F_L_ALL-Commitment-of-Traders-E-Mini-S-P-500-Stock-Index-Futures-Only-Legacy-Format-13874A
     	 ///SP Consolidated: https://www.quandl.com/data/CFTC/SPC_F_L_ALL-Commitment-of-Traders-S-P-500-Consolidated-Futures-Only-Legacy-Format-13874
  		///NQ MIni: https://www.quandl.com/data/CFTC/NQ_F_L_ALL-Commitment-of-Traders-Nasdaq-100-Stock-Index-Mini-Futures-Only-Legacy-Format-209742
		
		///Two Year: https://www.quandl.com/data/CFTC/TU_F_ALL-Commitment-of-Traders-2-Year-U-S-Treasury-Notes-Futures-Only-042601
		////Five Year: https://www.quandl.com/data/CFTC/FV_F_ALL-Commitment-of-Traders-5-Year-U-S-Treasury-Notes-Futures-Only-044601
		////Ten Year: https://www.quandl.com/data/CFTC/TY_F_ALL-Commitment-of-Traders-10-Year-U-S-Treasury-Notes-Futures-Only-043602
		////US Bonds: https://www.quandl.com/data/CFTC/US_F_L_ALL-Commitment-of-Traders-U-S-Treasury-Bonds-Futures-Only-Legacy-Format-020601
		/// 
		
		//To Add References to NS and To Export Files with References:
		//Say you need to add a reference to, System.IO.Compression.FileSystem.dll, so you can unzip files, or System.Net.Http.dll, so you can download files, what you need to do is shut down NT, open MyDocs>NT8>Config file in notepad, search “References”, copy a line, and paste it, then add the reference you want.  For example,
		// <string>System.IO.Compression.FileSystem.dll</string>
		//Then upon exporting this file, make sure in addition to the indicator/strategy, you must also click Add>References and select the ones that are needed.
	}
	
	public enum ContractEnum1  ///Enum, allows user to select from drop down.
	{
		Wheat, //"WHEAT-SRW - CHICAGO BOARD OF TRADE",
		Corn,
		Beans,
		BeanOil,
		SoybeanMeal,
		Gold,
		Silver,
		Copper,
		Platinum,
		Crude,
		RBOB,
		Sugar,
		
		AussieDollar,
		BritishPound,
		CanadianDollar,
		Euro,
		Yen,
		SwissFranc,

		DowConsolidated,
		DowMini,
		SPConsolidated,
		SPMini,
		NQConsolidated,
		NQMini,
		ZT,
		ZF,
		ZN,
		ZB,	
	}
	 
	
	public class myCustomClass  //Create Custom Object, an object with 2 objects inside..  //An object, with 2 objects inside.
	{
		public DateTime myTime {get; set;}
		public double myOI {get; set;}
	}
	
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private AlanIndicators.OpenInterestARP[] cacheOpenInterestARP;
		public AlanIndicators.OpenInterestARP OpenInterestARP(NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			return OpenInterestARP(Input, contractEnum);
		}

		public AlanIndicators.OpenInterestARP OpenInterestARP(ISeries<double> input, NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			if (cacheOpenInterestARP != null)
				for (int idx = 0; idx < cacheOpenInterestARP.Length; idx++)
					if (cacheOpenInterestARP[idx] != null && cacheOpenInterestARP[idx].ContractEnum == contractEnum && cacheOpenInterestARP[idx].EqualsInput(input))
						return cacheOpenInterestARP[idx];
			return CacheIndicator<AlanIndicators.OpenInterestARP>(new AlanIndicators.OpenInterestARP(){ ContractEnum = contractEnum }, input, ref cacheOpenInterestARP);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.AlanIndicators.OpenInterestARP OpenInterestARP(NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			return indicator.OpenInterestARP(Input, contractEnum);
		}

		public Indicators.AlanIndicators.OpenInterestARP OpenInterestARP(ISeries<double> input , NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			return indicator.OpenInterestARP(input, contractEnum);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.AlanIndicators.OpenInterestARP OpenInterestARP(NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			return indicator.OpenInterestARP(Input, contractEnum);
		}

		public Indicators.AlanIndicators.OpenInterestARP OpenInterestARP(ISeries<double> input , NinjaTrader.NinjaScript.Indicators.AlanIndicators.ContractEnum1 contractEnum)
		{
			return indicator.OpenInterestARP(input, contractEnum);
		}
	}
}

#endregion
